/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.slabfish.condition;

import com.minecraftabnormals.environmental.common.entity.SlabfishEntity;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishManager;
import com.minecraftabnormals.environmental.common.slabfish.SlabfishType;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ITag;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SlabfishConditionContext {
    private final Event event;
    private final LazyValue<Random> random;
    private final LazyValue<String> name;
    private final LazyValue<BlockPos> pos;
    private final LazyValue<Biome> biome;
    private final LazyValue<Boolean> inRaid;
    private final LazyValue<BlockState> inBlock;
    private final LazyValue<FluidState> inFluid;
    private final LazyValue<Boolean> dayTime;
    private final LazyValue<Boolean> nightTime;
    private final LazyValue<Integer> light;
    private final Map<LightType, LazyValue<Integer>> lightTypes;
    private final LazyValue<ResourceLocation> dimension;
    private final LazyValue<ResourceLocation> slabfishType;
    private final LazyValue<Boolean> breederInsomnia;
    private final Pair<SlabfishType, SlabfishType> parents;

    private SlabfishConditionContext(SlabfishEntity slabfish, Event event, @Nullable ServerPlayerEntity breeder, @Nullable SlabfishEntity parent1, @Nullable SlabfishEntity parent2) {
        ServerWorld world = (ServerWorld)slabfish.func_130014_f_();
        this.event = event;
        this.random = new LazyValue(() -> ((ServerWorld)world).func_201674_k());
        this.name = new LazyValue(() -> slabfish.func_145748_c_().getString().trim());
        this.pos = new LazyValue(() -> new BlockPos(slabfish.func_213303_ch()));
        this.biome = new LazyValue(() -> world.func_226691_t_((BlockPos)this.pos.func_179281_c()));
        this.inRaid = new LazyValue(() -> world.func_217475_c_((BlockPos)this.pos.func_179281_c()) != null);
        this.inBlock = new LazyValue(() -> world.func_180495_p((BlockPos)this.pos.func_179281_c()));
        this.inFluid = new LazyValue(() -> world.func_204610_c((BlockPos)this.pos.func_179281_c()));
        this.dayTime = new LazyValue(() -> ((ServerWorld)world).func_72935_r());
        this.nightTime = new LazyValue(() -> ((ServerWorld)world).func_226690_K_());
        this.light = new LazyValue(() -> world.func_201696_r((BlockPos)this.pos.func_179281_c()));
        this.lightTypes = new HashMap<LightType, LazyValue<Integer>>();
        for (LightType lightType : LightType.values()) {
            this.lightTypes.put(lightType, (LazyValue<Integer>)new LazyValue(() -> world.func_226658_a_(lightType, (BlockPos)this.pos.func_179281_c())));
        }
        this.dimension = new LazyValue(() -> world.func_234923_W_().func_240901_a_());
        this.slabfishType = new LazyValue(slabfish::getSlabfishType);
        this.breederInsomnia = new LazyValue(() -> breeder != null && breeder.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n)) >= 72000 && world.func_226690_K_());
        SlabfishManager slabfishManager = SlabfishManager.get((IWorldReader)world);
        this.parents = parent1 != null && parent2 != null ? new ImmutablePair((Object)slabfishManager.getSlabfishType(parent1.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH), (Object)slabfishManager.getSlabfishType(parent2.getSlabfishType()).orElse(SlabfishManager.DEFAULT_SLABFISH)) : null;
    }

    public static SlabfishConditionContext spawned(SlabfishEntity slabfish) {
        return new SlabfishConditionContext(slabfish, Event.SPAWN, null, null, null);
    }

    public static SlabfishConditionContext rename(SlabfishEntity slabfish) {
        return new SlabfishConditionContext(slabfish, Event.RENAME, null, null, null);
    }

    public static SlabfishConditionContext lightning(SlabfishEntity slabfish) {
        return new SlabfishConditionContext(slabfish, Event.LIGHTNING, null, null, null);
    }

    public static SlabfishConditionContext breeding(SlabfishEntity slabfish, @Nullable ServerPlayerEntity breeder, SlabfishEntity parent1, SlabfishEntity parent2) {
        return new SlabfishConditionContext(slabfish, Event.BREED, breeder, parent1, parent2);
    }

    public Event getEvent() {
        return this.event;
    }

    public Random getRandom() {
        return (Random)this.random.func_179281_c();
    }

    public String getName() {
        return (String)this.name.func_179281_c();
    }

    public BlockPos getPos() {
        return (BlockPos)this.pos.func_179281_c();
    }

    public Biome getBiome() {
        return (Biome)this.biome.func_179281_c();
    }

    public boolean isDay() {
        return (Boolean)this.dayTime.func_179281_c();
    }

    public boolean isNight() {
        return (Boolean)this.nightTime.func_179281_c();
    }

    public boolean isInRaid() {
        return (Boolean)this.inRaid.func_179281_c();
    }

    public boolean isInBlock(Block block) {
        return ((BlockState)this.inBlock.func_179281_c()).func_203425_a(block);
    }

    public boolean isInBlock(ITag<Block> tag) {
        return ((BlockState)this.inBlock.func_179281_c()).func_235714_a_(tag);
    }

    public boolean isInFluid(ITag<Fluid> tag) {
        return ((FluidState)this.inFluid.func_179281_c()).func_206884_a(tag);
    }

    public int getLight() {
        return (Integer)this.light.func_179281_c();
    }

    public int getLightFor(LightType lightType) {
        return (Integer)this.lightTypes.get(lightType).func_179281_c();
    }

    public ResourceLocation getDimension() {
        return (ResourceLocation)this.dimension.func_179281_c();
    }

    public ResourceLocation getSlabfishType() {
        return (ResourceLocation)this.slabfishType.func_179281_c();
    }

    public boolean isBreederInsomnia() {
        return (Boolean)this.breederInsomnia.func_179281_c();
    }

    @Nullable
    public Pair<SlabfishType, SlabfishType> getParentTypes() {
        return this.parents;
    }

    public static enum Event {
        SPAWN,
        RENAME,
        LIGHTNING,
        BREED;

    }
}

